/*
 * @brief LPC15xx start stop driver
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef __START_STOP_H_
#define __START_STOP_H_

#include "board.h"



#define counterH_start (5000)
#define counterH_stop  (2000)

#define counterL_start (3000)
#define counterL_stop  (2500)

/* Match register reload macro definitions */
#define reload_deactivate_L(value) (LPC_SCT0->MATCHREL[0].L = (value));
#define reload_activate_L(value)   (LPC_SCT0->MATCHREL[0].L = (value));
#define reload_activate_H(value)   (LPC_SCT0->MATCHREL[1].H = (value));
#define reload_deactivate_H(value) (LPC_SCT0->MATCHREL[1].H = (value));

#ifdef __cplusplus
extern "C" {
#endif

void start_stop_init(void);

#ifdef __cplusplus
}
#endif

#endif /* __START_STOP_H_ */
